# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1: Start with Cooperate
        return "C"
    
    # Analyze opponent's code for deterministic patterns
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    is_random = "random" in opponent_program_code
    
    if always_d:
        return "D"
    if always_c:
        # Exploit always-cooperate by defecting every 3rd round
        if len(my_history) % 3 == 0:
            return "D"
        else:
            return "C"
    if is_random:
        # Stick to Tit-for-Tat against random opponents
        return opp_history[-1]
    
    # Default to Tit-for-Tat with forgiveness
    if opp_history[-1] == "D":
        # Check if opponent has defected multiple times in a row
        if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
            return "D"
        else:
            return "D" if random.random() < 0.1 else "C"  # Small chance to forgive
    else:
        return "C"